<?php namespace PRKSMSApp\Gateways\Classes;

use PRKSMSApp\Gateways\Interfaces\SMSInterface;

use stdClass;

class Ippanel implements SMSInterface{

    const VerifySMS_API_URL = 'https://ippanel.com/';
    const API_URL = 'https://ippanel.com/services.jspd/';
    const API_URL_V1 = "http://api.ippanel.com/api/v1/";

    private static $instance;

    private $prk_getways_sms_options;

    private $username;

    private $password;

    private $from;

    private $api_key;

    private $phonebook_id;

    public static function get_instance($prk_getways_options) {
       
        if ( is_null( self::$instance ) ) {
            self::$instance = new self($prk_getways_options);
        }
		
		return self::$instance;
	}


    public function __construct($prk_getways_options)
    {
        $this->prk_getways_sms_options = $prk_getways_options;

        $this->username = $this->prk_getways_sms_options->username;

        $this->password = html_entity_decode($this->prk_getways_sms_options->password);

        $this->from = $this->prk_getways_sms_options->from;

        $this->api_key = $this->prk_getways_sms_options->api_key;

        $this->phonebook_id = $this->prk_getways_sms_options->phonebook_id;


    }

    public function sendBulkSMS($text, $mobiles){

        $responseData = new stdClass;

        $responseData->status = 0;

        $responseData->data = false;

		$param =[
            'uname'=>$this->username,
            'pass'=>$this->password,
            'from'=>$this->from,
            'message'=>$text,
            'to'=>json_encode($mobiles),
            'op'=>'send'
        ];
					
		$handler = curl_init(self::API_URL);             
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, $param);                       
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, false);
		$response = curl_exec($handler);
		$response = json_decode($response);
        
        if(is_array($response)){

            $responseData->status = 1;

            $responseData->data = $response[1];;
            
        }

                    
		return $responseData;
        
    }


    public function addNumberInPhonebook($mobile){

        $responseData = new stdClass;

        $responseData->status = 0;

        $responseData->data = false;


        $list[] = (object) [
            'number'       => $mobile,
            'name'         => "کاربر",
            'phonebook_id' => $this->phonebook_id
        ];

        $param = [
            'list' => $list,
        ];

        $url = self::API_URL_V1."phonebook/numbers-add-list";			
		$handler = curl_init($url);             
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($param));                       
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($handler, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization:' . $this->api_key,
        ]); 
		$response = curl_exec($handler);

 
		$response = json_decode($response);
     
        if(is_array($response) && $response['status']== 'OK' && $response['code']==200 ){

            $responseData->status = 1;

            $responseData->data = $response['data'];;
            
        }

                    
		return $responseData;
        
    }

    public function sendVerifySMS($parameters, $templateId, $to)
	{
        $responseData = new stdClass;

        $responseData->status = 0;

        $parameters=array_column($parameters['params'], 'value','name');

        $text = [];

        if (empty($parameters) || empty($templateId) || empty($to)) {

            error_log("sms parameter check");

            return '0';

        }

        preg_match_all("/#([a-zA-Z]+)#/",$this->prk_getways_sms_options->sms_text,$matches_variables);

        foreach($matches_variables[1] as $variable){

            if(isset($parameters[strtolower($variable)])){

                $text[$variable] = $parameters[strtolower($variable)];

            }

        }

        $url = self::VerifySMS_API_URL . "patterns/pattern?username=" . $this->username . "&password=" . urlencode($this->password) . "&from={$this->from}&to=" . json_encode($to) . "&input_data=" . urlencode(json_encode($text)) . "&pattern_code={$templateId}";
       
        $handler = curl_init($url);

        curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($handler, CURLOPT_POSTFIELDS, $text);

        curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");

        $response = curl_exec($handler);

        curl_close($handler);

        if(intval($response)){

            $responseData->status = 1;            
        }
        
        return  $responseData;

    }
    public function getCredit(){
        $responseData = new stdClass;

        $responseData->status = 0;

        $responseData->data = false;

        $param = array
        (
            'uname'=>$this->username,
            'pass'=>$this->password,
            'op'=>'credit'
        );
        
        $handler = curl_init(self::API_URL);             
        curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($handler, CURLOPT_POSTFIELDS, $param);                       
        curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($handler);

        $response = json_decode($response);
        if(is_array($response)){

            $responseData->status = 1;

            $responseData->data = $response[1];
            
        }

                    
		return $responseData;

        
    }

    




  


}