<?php

// define('PHP_PRK_ROOT',get_template_directory());

// require PHP_PRK_ROOT.'/vendor/autoload.php';

add_action('csf_prk_option_save_after', 'prk_generate_dynamic_styles_modular', 10, 2);


add_action('wp_enqueue_scripts', function () {
    $path = get_stylesheet_directory_uri() . '/assets/css/dynamic-style.css';
    $file = get_stylesheet_directory() . '/assets/css/dynamic-style.css';

    if (file_exists($file)) {
        wp_enqueue_style('parskala-dynamic-style', $path, [], filemtime($file));
    }
});

function prk_generate_dynamic_styles_modular($request, $instance) {
    $css = '';

    $global_styles = [

        // استایل های صفحه محصول
        'color_info_box_product' => [
            'type' => 'color',
            'property' => 'color',
            'selectors' => [
                '.woocommerce .des-left div.quantity a.plus',
                '.woocommerce .des-left div.quantity a.minus',
                '.woocommerce .des-left div.quantity input.qty',
                '.stills_contienr .shop_names .name',
                '.operation_stillses',
                '.cart-pro bdi',
                '.col-single1 .des-left .share-square::before',
                '.col-single1 .des-left .ui-box',
                '.col-single1 .des-left .seller-feedback .seller-feedback-item',
                'body .product-seller-info .product-seller-row .product-seller-row-icon i',
                'body.product-single .woocommerce div.product .woocommerce-variation-availability p.stock',
                'body.product-single .woocommerce div.product .cart-pro del span bdi',
                'body.product-single .product-seller-info .product-seller-row .product-seller-row-detail .product-seller-row-detail-title',
            ]
        ],

        'color_add_cart_btn_product' => [
            'type' => 'background',
            'property' => 'background',
            'selectors' => [
                '.single-product .single_add_to_cart_button.button',
            ]
        ],

        'shadow_add_cart_btn_product' => [
            'type' => 'box-shadow',
            'selectors' => [
                '.single-product .single_add_to_cart_button.button',
            ]
        ],
        
    ];

    $single_product_styles = [
       'border_radius_info_box' => [
            'type' => 'border-radius',
            'unit' => 'px',
            'important' => true,
            'selectors' => [
                '.col-single1 .des-left .ui-box, .col-single1 .des-left .tippy-content'
                ]
        ],
        'prk_background_single_pro' => [
            'type' => 'background',
            'property' => 'background-color',
            'selectors' => ['body.product-single']
        ],
        'gradient_info_box_product' => [
            'type' => 'background-gradient',
            'property' => 'background',
            'selectors' => [
                '.col-single1 .des-left .ui-box',
                '.col-single1 .des-left .tippy-content'
            ]
        ],
        'border_info_box_product' => [
            'type' => 'color',
            'property' => 'color',
            'selectors' => [
                '.parskala-update-price',
                '.col-single1 .des-left .tippy-content',
                '.product-seller-info .product-seller-row::after'
            ],
            'extra_css' => [
                '.product-seller-info .product-seller-row::after' => 'background-color',
            ]
        ],
        'back_add_cart_btn_product' => [
            'type' => 'background-gradient',
            'property' => 'background',
            'selectors' => [
                '.single-product .woocommerce div.product form.cart .button.single_add_to_cart_button',
            ]
        ],
    ];

    $total_cart_styles = [

        'gradient_total_box_product' => [
            'type' => 'background-gradient',
            'property' => 'background',
            'selectors' => [
                'body .shop_table.table-shop-cart-user,
                 body.ceckout_page .shop_table.woocommerce-checkout-review-order-table,
                 body.ceckout_page .woocommerce-checkout-payment,
                 body.ceckout_page .woocommerce-checkout-payment ul li div.payment_box
            ']
        ],

        'border_total_box_product' => [
            'type' => 'border-color',
            'property' => 'color',
            'selectors' => [
                'body .collateral-order-user table.shop_table .woocommerce-shipping-totals,
                 body .totals-order-user .order-total,
                 .woocommerce .collateral-order-user table.shop_table .woocommerce-shipping-totals,
                 tr.woocommerce-shipping-totals.shipping td ul li
            ']
        ],

        'color_total_box_product' => [

            [
                'type' => 'raw-style',
                'value' => 'background: transparent;',
                'important' => true, // یا true
                'custom_selectors' => ['body .woocommerce-checkout #payment div.payment_box'],
            ],

            [
                'type' => 'color',
                'property' => 'color',
                'important' => true, // یا true

                'selectors' => [
                    '.shipping-calculator-form .select2-selection--single .select2-selection__rendered',
                    '.totals-order-user table.shop_table tr.order-total td .woocommerce-Price-amount',
                    'body .collateral-order-user p.woocommerce-shipping-destination',
                    '.cart-subtotal .woocommerce-Price-amount',
                    'body .prk_cart table.shop_table th',
                    'body .prk_cart table.shop_table td',
                    'body .totals-order-user table.shop_table tr.order-total td .woocommerce-Price-amount',
                    'body .woocommerce form .form-row label',
                    'body .woocommerce-form-row label',
                    'body.ceckout_page div.place-order .prk-order-total',
                    'body.ceckout_page .shop_table.woocommerce-checkout-review-order-table tbody tr.cart-subtotal th',
                    'body .woocommerce table.shop_table th',
                    'body .woocommerce table.shop_table td',
                    'body.ceckout_page .woocommerce-checkout-payment ul li::before',
                    'body.ceckout_page .woocommerce-checkout-payment ul li label',
                    'body.ceckout_page .woocommerce .shop_table  ul#shipping_method li label .woocommerce-Price-amount',
                    'body.ceckout_page .woocommerce-checkout-payment ul li div.payment_box p',
                    'body.ceckout_page .shop_table.woocommerce-checkout-review-order-table tbody tr.tax-total td',
                    'body.ceckout_page .shop_table.woocommerce-checkout-review-order-table tbody tr.order-total td',
                    'body.ceckout_page .shop_table.woocommerce-checkout-review-order-table tbody tr.order-total th',
                ]
            ],

        ],

        'back_total_btn_product' => [
            'type' => 'background-gradient',
            'property' => 'background',
            'selectors' => [
                'body a.checkout-button.button',
                'body .woocommerce-checkout .form-row.place-order button#place_order'
                ]
        ],

        'color_total_btn_product' => [
            'type' => 'color',
            'property' => 'color',
            'selectors' => [
            'a.checkout-button.button',
            'body .woocommerce-checkout .form-row.place-order button#place_order'
            ]
        ],

        'shadow_total_btn_product' => [
            'type' => 'box-shadow',
            'selectors' => [
                'a.checkout-button.button',
                'body .woocommerce-checkout .form-row.place-order button#place_order'
            ]
        ],

        'border_radius_total_box' => [
        'type' => 'border-radius',
        'unit' => 'px',
        'important' => true,
        'selectors' => [
            'body .shop_table.table-shop-cart-user',
            'body .shop_table_responsive.table-shop-cart-user',
            'body.ceckout_page .shop_table.woocommerce-checkout-review-order-table, body.ceckout_page .woocommerce-checkout-payment'
            ]
        ],

    ];



    $css .= generate_css_from_options($global_styles);
    $css .= generate_css_from_options($total_cart_styles);
    $css .= generate_css_from_options($single_product_styles);

    // ذخیره در فایل
    $css_path = get_stylesheet_directory() . '/assets/css/dynamic-style.css';
    file_put_contents($css_path, $css);
}


/**
 *  تولید CSS از یک آرایه تنظیمات
 */
function generate_css_from_options($styles) {
    $css = '';
    $fallback_ids = [
    'back_add_cart_btn_product',
    // هر ID دیگه‌ای که fallback بخواد
    ];
    foreach ($styles as $option_id => $data) {
        $value = prk_option($option_id);
        if (!$value) continue;

        // اگه نوع‌های مختلف داشت (variants)، بررسی کن
        $variants = isset($data['type']) ? [$data] : $data;

        foreach ($variants as $variant) {
            $type = $variant['type'] ?? 'color';
            $important = isset($variant['important']) && $variant['important'] === false ? '' : ' !important';

            // 🎨 رنگ ساده
            if ($type === 'color' && is_string($value)) {
                if (!empty($variant['selectors'])) {
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  {$variant['property']}: {$value}{$important};\n";
                    $css .= "}\n";
                }

                // استایل‌های اضافی
                if (!empty($variant['extra_css'])) {
                    foreach ($variant['extra_css'] as $selector => $prop) {
                        $css .= "{$selector} {\n";
                        $css .= "  {$prop}: {$value}{$important};\n";
                        $css .= "}\n";
                    }
                }
            }

            // 🎨 سایه
            elseif ($type === 'box-shadow' && is_string($value)) {
                if (!empty($variant['selectors'])) {
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  box-shadow: 0px 0px 21.92px 0px {$value}{$important};\n";
                    $css .= "}\n";
                }
            }

            // 🎨 رنگ border
            elseif ($type === 'border-color' && is_string($value)) {
                if (!empty($variant['selectors'])) {
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  border-color: {$value}{$important};\n";
                    $css .= "}\n";
                }
            }

            // 🧩 بک‌گراند ساده
            elseif ($type === 'background' && is_array($value) && !empty($value['background-color'])) {
                if (!empty($variant['selectors'])) {
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  {$variant['property']}: {$value['background-color']}{$important};\n";
                    $css .= "}\n";
                }
            }

            // 🌀 گرادینت بک‌گراند با fallback
            elseif ($type === 'background-gradient') {
                $main_val = $value;

                $from = $main_val['background-color'] ?? null;
                $to   = $main_val['background-gradient-color'] ?? null;
                $dir  = $main_val['background-gradient-direction'] ? $main_val['background-gradient-direction'] : 'to right';

                // فقط برای IDهای خاص fallback اعمال کن
                if ((!$from || !$to) && in_array($option_id, $fallback_ids)) {
                    $gradient_org = prk_option('gradient_general_color');
                    if ($gradient_org && !empty($gradient_org['background-color']) && !empty($gradient_org['background-gradient-color'])) {
                        $from = $gradient_org['background-color'];
                        $to   = $gradient_org['background-gradient-color'];
                        $dir  = $main_val['background-gradient-direction'] ? $main_val['background-gradient-direction'] : 'to right';
                    } else {
                        $fallback = prk_option('general_color');
                        if ($fallback) {
                            $from = $fallback;
                            $to   = $fallback;
                        }
                    }
                }

                if ($from && $to && !empty($variant['selectors'])) {
                    $gradient = "linear-gradient({$dir}, {$from}, {$to})";
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  {$variant['property']}: {$gradient}{$important};\n";
                    $css .= "}\n";
                }
            }

            // 🧪 حاشیه انحنای

            elseif ($type === 'border-radius' && is_numeric($value)) {
                $unit = $variant['unit'] ?? 'px';

                if (!empty($variant['selectors'])) {
                    $css .= implode(",\n", $variant['selectors']) . " {\n";
                    $css .= "  border-radius: {$value}{$unit}{$important};\n";
                    $css .= "}\n";
                }
            }

            // 🧪 استایل دستی
            elseif ($type === 'raw-style' && !empty($variant['value']) && !empty($variant['custom_selectors'])) {
                foreach ($variant['custom_selectors'] as $selector) {
                    $css .= "{$selector} {\n";
                    $lines = explode(';', $variant['value']);
                    foreach ($lines as $line) {
                        $line = trim($line);
                        if (!$line) continue;
                        $css .= "  {$line}{$important};\n";
                    }
                    $css .= "}\n";
                }
            }
        }
    }

    return $css;
}
